package imagem;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class ImagemFiltros {

	
	
	public static final int RED = 0;
	public static final int BLUE = 1;
	public static final int GREEN = 2;
	public static final int GRAY = 3;
	
	public static int limiteImg(int i) {
		if(i > 255)
			return 255;
		else if(i < 0)
			return 0;
		else
			return i;
	}
	
	
	// Aceita os seguintes valores:
	// vermelho, azul, verde e cinza
	public static void changecolor(Imagem img, int color) {
		
		int[][][] matriz = img.getMatriz();
		
        for (int linha = 0; linha < matriz.length; linha++) {
            for (int coluna = 0; coluna < matriz[linha].length; coluna++) {
            	
                int r = matriz[linha][coluna][0];
                int g = matriz[linha][coluna][1];
                int b = matriz[linha][coluna][2];
                
                if(color == RED){
                    matriz[linha][coluna][0] = r;
                    matriz[linha][coluna][1] = 0;
                    matriz[linha][coluna][2] = 0;
                }
                if(color == GREEN){
                    matriz[linha][coluna][0] = 0;
                    matriz[linha][coluna][1] = g;
                    matriz[linha][coluna][2] = 0;
                }if(color == BLUE){
                    matriz[linha][coluna][0] = 0;
                    matriz[linha][coluna][1] = 0;
                    matriz[linha][coluna][2] = b;
                }
                if(color == GRAY){
                    int cinza = (r + g + b) / 3;
                    matriz[linha][coluna][0] = cinza;
                    matriz[linha][coluna][1] = cinza;
                    matriz[linha][coluna][2] = cinza;
                }
            }
        }
        img.lerMatriz();
    }

	public static void binariza(Imagem img, int limiar) {
		int[][][] matriz = img.getMatriz();
		
        for (int linha = 0; linha < matriz.length; linha++) {
            for (int coluna = 0; coluna < matriz[linha].length; coluna++) {
                int r = matriz[linha][coluna][0] ;
                int g = matriz[linha][coluna][1] ;
                int b = matriz[linha][coluna][2] ;
                int cinza = (r + g + b) / 3;
                if (cinza > limiar) {
                    r=255;
                } else {
                    r=0;
                }
                
                matriz[linha][coluna][0] = r;
                matriz[linha][coluna][1] = r;
                matriz[linha][coluna][2] = r;
            }
        }
        img.lerMatriz();
    }
	
	public static void media3x3(Imagem img) {
		
		int[][][] matriz = img.getMatriz();
        int[][][] matriz2 = matriz.clone();
        
        
        for (int linha = 1; linha < matriz.length -2; linha++) {
            for (int coluna = 1; coluna < matriz[linha].length -2; coluna++) {
                int r = (1 * matriz[linha -1][coluna -1][0] +
                        1 * matriz[linha -1][coluna +1][0] +
                        1 * matriz[linha -1][coluna][0] +
                        1 * matriz[linha +1][coluna -1][0] +
                        1 * matriz[linha +1][coluna +1][0] +
                        1 * matriz[linha +1][coluna][0] +
                        1 * matriz[linha][coluna -1][0] +
                        1 * matriz[linha][coluna +1][0] +
                        1 * matriz[linha][coluna][0] )/9;
                
                int g = (1 * matriz[linha -1][coluna -1][1] +
                        1 * matriz[linha -1][coluna +1][1] +
                        1 * matriz[linha -1][coluna][1] +
                        1 * matriz[linha +1][coluna -1][1] +
                        1 * matriz[linha +1][coluna +1][1] +
                        1 * matriz[linha +1][coluna][1] +
                        1 * matriz[linha][coluna -1][1] +
                        1 * matriz[linha][coluna +1][1] +
                        1 * matriz[linha][coluna][1] )/9;
                
                int b = (1 * matriz[linha -1][coluna -1][2] +
                        1 * matriz[linha -1][coluna +1][2] +
                        1 * matriz[linha -1][coluna][2] +
                        1 * matriz[linha +1][coluna -1][2] +
                        1 * matriz[linha +1][coluna +1][2] +
                        1 * matriz[linha +1][coluna][2] +
                        1 * matriz[linha][coluna -1][2] +
                        1 * matriz[linha][coluna +1][2] +
                        1 * matriz[linha][coluna][2] )/9;
                
                matriz2[linha][coluna][0] = r;
                matriz2[linha][coluna][1] = g;
                matriz2[linha][coluna][2] = b;
            }
        }
        img.lerMatriz();
    }
    	
	public static void mediana3x3(Imagem img) {
		int[][][] matriz = img.copiaMatriz();
        int[][][] matriz2 = img.getMatriz();
        int[] mediana = new int[9];
        
        for (int coluna = 1; coluna < matriz.length -2; coluna++) {
            for (int linha = 1; linha< matriz[coluna].length -2; linha++) {
  
                // INICIO DO PROCESSAMENTO DO RED
                mediana[0] = 1 * matriz[coluna -1][linha -1][0];
                mediana[1] = 1 * matriz[coluna -1][linha +1][0];
                mediana[2] = 1 * matriz[coluna -1][linha][0];
                mediana[3] = 1 * matriz[coluna +1][linha -1][0];
                mediana[4] = 1 * matriz[coluna +1][linha +1][0];
                mediana[5] = 1 * matriz[coluna +1][linha][0];
                mediana[6] = 1 * matriz[coluna][linha -1][0];
                mediana[7] = 1 * matriz[coluna][linha +1][0];
                mediana[8] = 1 * matriz[coluna][linha][0];
                
                Arrays.sort(mediana);
                // Red
                matriz2[coluna][linha][0] = mediana[mediana.length/2];

                // INICIO DO PROCESSAMENTO DO GREEN
                mediana[0] = 1 * matriz[coluna -1][linha -1][1];
                mediana[1] = 1 * matriz[coluna -1][linha +1][1];
                mediana[2] = 1 * matriz[coluna -1][linha][1];
                mediana[3] = 1 * matriz[coluna +1][linha -1][1];
                mediana[4] = 1 * matriz[coluna +1][linha +1][1];
                mediana[5] = 1 * matriz[coluna +1][linha][1];
                mediana[6] = 1 * matriz[coluna][linha -1][1];
                mediana[7] = 1 * matriz[coluna][linha +1][1];
                mediana[8] = 1 * matriz[coluna][linha][1];
                
                Arrays.sort(mediana);
                // Green
                matriz2[coluna][linha][1] = mediana[mediana.length/2];

                // INICIO DO PROCESSAMENTO DO BLUE
                mediana[0] = 1 * matriz[coluna -1][linha -1][2];
                mediana[1] = 1 * matriz[coluna -1][linha +1][2];
                mediana[2] = 1 * matriz[coluna -1][linha][2];
                mediana[3] = 1 * matriz[coluna +1][linha -1][2];
                mediana[4] = 1 * matriz[coluna +1][linha +1][2];
                mediana[5] = 1 * matriz[coluna +1][linha][2];
                mediana[6] = 1 * matriz[coluna][linha -1][2];
                mediana[7] = 1 * matriz[coluna][linha +1][2];
                mediana[8] = 1 * matriz[coluna][linha][2];
                
                Arrays.sort(mediana);
                // Blue
                matriz2[coluna][linha][2] = mediana[mediana.length/2];

            }
        }
        img.lerMatriz();
    }
    
	public static void gaussianFilter(Imagem img){
		
		int[][][] matriz = img.copiaMatriz();
		int[][][] matriz2 = img.getMatriz();
		
		for(int linha = 2; linha < matriz.length -3; linha++)
			for(int coluna = 2; coluna < matriz[linha].length -3; coluna++) {
				
				//INICIO DO PROCESSAMENTO DO RED
				matriz2[linha][coluna][0] = limiteImg( 
						1/159 * (
						matriz[linha-2][coluna-2][0] * 2 +  // -------
						matriz[linha-2][coluna-1][0] * 4 +  //
						matriz[linha-2][coluna][0]   * 5 +  // Linha -2
						matriz[linha-2][coluna+1][0] * 4 +  //
						matriz[linha-2][coluna+2][0] * 2 +  // -------
						matriz[linha-1][coluna-2][0] * 4 +  // --------
						matriz[linha-1][coluna-1][0] * 9 +  //
						matriz[linha-1][coluna][0]   * 12 +  // Linha -1
						matriz[linha-1][coluna+1][0] * 9 +  //
						matriz[linha-1][coluna+2][0] * 4 +  // -------
						matriz[linha][coluna-2][0]   * 5 +  // -------
						matriz[linha][coluna-1][0]   * 12 +  //
						matriz[linha][coluna][0]     * 15 +  // Linha 0
						matriz[linha][coluna+1][0]   * 12 +  //
						matriz[linha][coluna+2][0]   * 5 +  // -------
						matriz[linha+1][coluna-2][0] * 4 +  // -------
						matriz[linha+1][coluna-1][0] * 9 +  //
						matriz[linha+1][coluna][0]   * 12 +  // Linha +1
						matriz[linha+1][coluna+1][0] * 9 +  //
						matriz[linha+1][coluna+2][0] * 4 +  // -------
						matriz[linha+2][coluna-2][0] * 2 +  // -------
						matriz[linha+2][coluna-1][0] * 4 +  //
						matriz[linha+2][coluna][0]   * 5 +  // Linha +2
						matriz[linha+2][coluna+1][0] * 4 +  //
						matriz[linha+2][coluna+2][0] * 2    // -------
						) * matriz[linha][coluna][0]
								); //fim limiteImg
				
				//INICIO DO PROCESSAMENTO DO GREEN
				matriz2[linha][coluna][0] = limiteImg(
						1/159 * (
						matriz[linha-2][coluna-2][1] * 2 +  // -------
						matriz[linha-2][coluna-1][1] * 4 +  //
						matriz[linha-2][coluna][1]   * 5 +  // Linha -2
						matriz[linha-2][coluna+1][1] * 4 +  //
						matriz[linha-2][coluna+2][1] * 2 +  // -------
						matriz[linha-1][coluna-2][1] * 4 +  // --------
						matriz[linha-1][coluna-1][1] * 9 +  //
						matriz[linha-1][coluna][1]   * 12 +  // Linha -1
						matriz[linha-1][coluna+1][1] * 9 +  //
						matriz[linha-1][coluna+2][1] * 4 +  // -------
						matriz[linha][coluna-2][1]   * 5 +  // -------
						matriz[linha][coluna-1][1]   * 12 +  //
						matriz[linha][coluna][1]     * 15 +  // Linha 0
						matriz[linha][coluna+1][1]   * 12 +  //
						matriz[linha][coluna+2][1]   * 5 +  // -------
						matriz[linha+1][coluna-2][1] * 4 +  // -------
						matriz[linha+1][coluna-1][1] * 9 +  //
						matriz[linha+1][coluna][1]   * 12 +  // Linha +1
						matriz[linha+1][coluna+1][1] * 9 +  //
						matriz[linha+1][coluna+2][1] * 4 +  // -------
						matriz[linha+2][coluna-2][1] * 2 +  // -------
						matriz[linha+2][coluna-1][1] * 4 +  //
						matriz[linha+2][coluna][1]   * 5 +  // Linha +2
						matriz[linha+2][coluna+1][1] * 4 +  //
						matriz[linha+2][coluna+2][1] * 2    // -------
						) * matriz[linha][coluna][1]
								); //fim limiteImg
				
				//INICIO DO PROCESSAMENTO DO BLUE
				matriz2[linha][coluna][0] = limiteImg(
						1/159 * (
						matriz[linha-2][coluna-2][2] * 2 +  // -------
						matriz[linha-2][coluna-1][2] * 4 +  //
						matriz[linha-2][coluna][2]   * 5 +  // Linha -2
						matriz[linha-2][coluna+1][2] * 4 +  //
						matriz[linha-2][coluna+2][2] * 2 +  // -------
						matriz[linha-1][coluna-2][2] * 4 +  // --------
						matriz[linha-1][coluna-1][2] * 9 +  //
						matriz[linha-1][coluna][2]   * 12 +  // Linha -1
						matriz[linha-1][coluna+1][2] * 9 +  //
						matriz[linha-1][coluna+2][2] * 4 +  // -------
						matriz[linha][coluna-2][2]   * 5 +  // -------
						matriz[linha][coluna-1][2]   * 12 +  //
						matriz[linha][coluna][2]     * 15 +  // Linha 0
						matriz[linha][coluna+1][2]   * 12 +  //
						matriz[linha][coluna+2][2]   * 5 +  // -------
						matriz[linha+1][coluna-2][2] * 4 +  // -------
						matriz[linha+1][coluna-1][2] * 9 +  //
						matriz[linha+1][coluna][2]   * 12 +  // Linha +1
						matriz[linha+1][coluna+1][2] * 9 +  //
						matriz[linha+1][coluna+2][2] * 4 +  // -------
						matriz[linha+2][coluna-2][2] * 2 +  // -------
						matriz[linha+2][coluna-1][2] * 4 +  //
						matriz[linha+2][coluna][2]   * 5 +  // Linha +2
						matriz[linha+2][coluna+1][2] * 4 +  //
						matriz[linha+2][coluna+2][2] * 2    // -------
						) * matriz[linha][coluna][2]
								); //fim limiteImg
			}
		img.lerMatriz();
	}
	
	public static void sobel(Imagem img) {
		
		int[][][] matriz = img.getMatriz();
        int[][][] sobelX = img.copiaMatriz();
        int[][][] sobelY = img.copiaMatriz();
        
        for (int linha = 1; linha < matriz.length -2; linha++)
            for (int coluna = 1; coluna < matriz[linha].length -2; coluna++)
            	for(int cor = 0; cor < 3; cor++){
            		
            		
	            	sobelX[linha][coluna][cor] = limiteImg(
	                		-1 * matriz[linha-1][coluna-1][cor] +
	                        -2 * matriz[linha-1][coluna][cor] +
	                        -1 * matriz[linha-1][coluna+1][cor] +
	                        
	                         0 * matriz[linha][coluna-1][cor] +
	                         0 * matriz[linha][coluna][cor] +
	                         0 * matriz[linha][coluna+1][cor] +
	                        
	                         1 * matriz[linha+1][coluna-1][cor] +
	                         2 * matriz[linha+1][coluna][cor] +
	                         1 * matriz[linha+1][coluna+1][cor]);
	            	
	            	sobelY[linha][coluna][cor] = limiteImg(
	                		-1 * matriz[linha-1][coluna-1][cor] +
	                         0 * matriz[linha-1][coluna][cor] +
	                         1 * matriz[linha-1][coluna+1][cor] +
	                        
	                        -2 * matriz[linha][coluna-1][cor] +
	                         0 * matriz[linha][coluna][cor] +
	                         2 * matriz[linha][coluna+1][cor] +
	                        
	                        -1 * matriz[linha+1][coluna-1][cor] +
	                         0 * matriz[linha+1][coluna][cor] +
	                         1 * matriz[linha+1][coluna+1][cor]);
	            	
	            	
	            	//Calculando o valor para colocar na matriz original
	            	matriz[linha][coluna][cor] = limiteImg((int)Math.sqrt(
	            			sobelX[linha][coluna][cor] * sobelX[linha][coluna][cor] +
	            			sobelY[linha][coluna][cor] * sobelY[linha][coluna][cor]
	            			));
            	
            	}// end for loop
        img.lerMatriz();
    }
	
	public static void laplaciana(Imagem img) {
		
		int[][][] alterada = img.getMatriz();
        int[][][] base = img.copiaMatriz();
        
        for (int linha = 1; linha < alterada.length -2; linha++)
            for (int coluna = 1; coluna < alterada[linha].length -2; coluna++)
            	for(int cor = 0; cor < 3; cor++){
            		
	            	alterada[linha][coluna][cor] = limiteImg(
	                		 1 * base[linha-1][coluna-1][cor] +
	                         1 * base[linha-1][coluna][cor] +
	                         1 * base[linha-1][coluna+1][cor] +
	                        
	                         1 * base[linha][coluna-1][cor] +
	                        -8 * base[linha][coluna][cor] +
	                         1 * base[linha][coluna+1][cor] +
	                        
	                         1 * base[linha+1][coluna-1][cor] +
	                         1 * base[linha+1][coluna][cor] +
	                         1 * base[linha+1][coluna+1][cor]);
            	
            	}// end for loop
        img.lerMatriz();
    }

	public static void mascaraLinha45Pos(Imagem img) {
	
		int[][][] alterada = img.getMatriz();
	    int[][][] base = img.copiaMatriz();
	    
	    for (int linha = 1; linha < alterada.length -2; linha++)
	        for (int coluna = 1; coluna < alterada[linha].length -2; coluna++)
	        	for(int cor = 0; cor < 3; cor++){
	        		
	            	alterada[linha][coluna][cor] = limiteImg(
	                		 2 * base[linha-1][coluna-1][cor] +
	                        -1 * base[linha-1][coluna][cor] +
	                        -1 * base[linha-1][coluna+1][cor] +
	                        
	                        -1 * base[linha][coluna-1][cor] +
	                         2 * base[linha][coluna][cor] +
	                        -1 * base[linha][coluna+1][cor] +
	                        
	                        -1 * base[linha+1][coluna-1][cor] +
	                        -1 * base[linha+1][coluna][cor] +
	                         2 * base[linha+1][coluna+1][cor]);
	        	
	        	}// end for loop
	    img.lerMatriz();
	}
	
	public static void mascaraLinha45Neg(Imagem img) {
		
		int[][][] alterada = img.getMatriz();
	    int[][][] base = img.copiaMatriz();
	    
	    for (int linha = 1; linha < alterada.length -2; linha++)
	        for (int coluna = 1; coluna < alterada[linha].length -2; coluna++)
	        	for(int cor = 0; cor < 3; cor++){
	        		
	            	alterada[linha][coluna][cor] = limiteImg(
	                		-1 * base[linha-1][coluna-1][cor] +
	                        -1 * base[linha-1][coluna][cor] +
	                         2 * base[linha-1][coluna+1][cor] +
	                        
	                        -1 * base[linha][coluna-1][cor] +
	                         2 * base[linha][coluna][cor] +
	                        -1 * base[linha][coluna+1][cor] +
	                        
	                         2 * base[linha+1][coluna-1][cor] +
	                        -1 * base[linha+1][coluna][cor] +
	                        -1 * base[linha+1][coluna+1][cor]);
	        	
	        	}// end for loop
	    img.lerMatriz();
	}

	public static void mascaraLinha45(Imagem img){
		
		// Aqui faremos o processamento de linhas -45 e + 45
		// O ngulo  calculado baseado no ngulo 0, que  de cima para baixo.
		int matrizNeg = 0;
	    int matrizPos = 0;
	    int[][][] alterada = img.getMatriz();
	    int[][][] base = img.copiaMatriz();
	    
	    for (int linha = 1; linha < base.length -2; linha++)
	        for (int coluna = 1; coluna < base[linha].length -2; coluna++)
	        	for(int cor = 0; cor < 3; cor++){
	        		
	            	matrizNeg = limiteImg(
	                		-1 * base[linha-1][coluna-1][cor] +
	                        -1 * base[linha-1][coluna][cor] +
	                         2 * base[linha-1][coluna+1][cor] +
	                        
	                        -1 * base[linha][coluna-1][cor] +
	                         2 * base[linha][coluna][cor] +
	                        -1 * base[linha][coluna+1][cor] +
	                        
	                         2 * base[linha+1][coluna-1][cor] +
	                        -1 * base[linha+1][coluna][cor] +
	                        -1 * base[linha+1][coluna+1][cor]);
	        	
	            	matrizPos = limiteImg(
	                		 2 * base[linha-1][coluna-1][cor] +
	                        -1 * base[linha-1][coluna][cor] +
	                        -1 * base[linha-1][coluna+1][cor] +
	                        
	                        -1 * base[linha][coluna-1][cor] +
	                         2 * base[linha][coluna][cor] +
	                        -1 * base[linha][coluna+1][cor] +
	                        
	                        -1 * base[linha+1][coluna-1][cor] +
	                        -1 * base[linha+1][coluna][cor] +
	                         2 * base[linha+1][coluna+1][cor]);
	            	
	            	alterada[linha][coluna][cor] = limiteImg(matrizPos + matrizNeg);
	        	}// end for loop
	    img.lerMatriz();
	    
	}

	public static int otsuTreshold(Imagem img) {
		
		BufferedImage original = img.getImagem();
        int[] histogram = imageHistogram(original);
        int total = original.getHeight() * original.getWidth();
        
        float sum = 0;
        for(int i=0; i<256; i++) sum += i * histogram[i];
        
        float sumB = 0;
        int wB = 0;
        int wF = 0;
        
        float varMax = 0;
        int threshold = 0;
 
        for(int i=0 ; i<256 ; i++) {
            wB += histogram[i];
            if(wB == 0) continue;
            wF = total - wB;
 
            if(wF == 0) break;
 
            sumB += (float) (i * histogram[i]);
            float mB = sumB / wB;
            float mF = (sum - sumB) / wF;
 
            float varBetween = (float) wB * (float) wF * (mB - mF) * (mB - mF);
 
            if(varBetween > varMax) {
                varMax = varBetween;
                threshold = i;
            }
        }
        return threshold;
    }
	
	public static int[] imageHistogram(BufferedImage input) {
		 
        int[] histogram = new int[256];
 
        for(int i=0; i<histogram.length; i++) histogram[i] = 0;
 
        for(int i=0; i<input.getWidth(); i++) {
            for(int j=0; j<input.getHeight(); j++) {
                int red = new Color(input.getRGB (i, j)).getRed();
                histogram[red]++;
            }
        }
 
        return histogram;
    }
	
}
